create or replace package body tbicds.PCK_AP_USERADMIN is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

   /*insert a user into the system*/
   procedure InsertSuatUser (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      pi_vProviderID      in varchar2,
      pi_nlocked          in number,
      pi_vName            in varchar2,
      pi_vRank            in varchar2,
      pi_nServiceID       in number,
      pi_vTitle           in varchar2,
      pi_vCorps           in varchar2,
      pi_vSquadron        in varchar2,
      pi_vOfficeSymbol    in varchar2,
      pi_vPhone           in varchar2,
      pi_vEmail           in varchar2,
      pi_vDimsID          in varchar2,
      pi_vUIDPWD          in varchar2,
      pi_nMustChgPwd      in number,
      pi_vSupervisorID    in varchar2,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
  
      v_vSql := 'insert into tbicds.app_user ('
                || 'provider_id, locked, name, rank, military_service_id, '
                || 'title, corps, unit, squadron, phone, '
                || 'email, dims_id, uidpwd, must_change_password, entry_date, '
                || 'supervisor_id) '
                || 'values ('
                || ':P0,:P1,:P2,:P3,:P4,:P5,:P6,:P7,:P8,:P9,:P10,:P11,:P12,:P13,:P14,:P15) ';
      execute immediate v_vSql using
         pi_vProviderID, pi_nLocked, pi_vName, pi_vRank, pi_nServiceID,
         pi_vTitle, pi_vCorps, pi_vSquadron, pi_vOfficeSymbol, pi_vPhone,
         pi_vEmail, pi_vDimsID, pi_vUIDPWD, pi_nMustChgPwd, sysdate,
         pi_vSupervisorID;
      commit;
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.InsertSuatUser(): ' || sqlErrm;
   end;
   
   /*update a user*/
   procedure UpdateSuatUser (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      pi_vProviderID      in varchar2,
      pi_vCurrentDimsID   in varchar2,
      pi_nlocked          in number,
      pi_vName            in varchar2,
      pi_vRank            in varchar2,
      pi_nServiceID       in number,
      pi_vTitle           in varchar2,
      pi_vCorps           in varchar2,
      pi_vSquadron        in varchar2,
      pi_vOfficeSymbol    in varchar2,
      pi_vPhone           in varchar2,
      pi_vEmail           in varchar2,
      pi_vDimsID          in varchar2,
      pi_vUIDPWD          in varchar2,
      pi_nMustChgPwd      in number,
      pi_vSupervisorID    in varchar2,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.app_user set '
                || 'locked = :P0, '
                || 'name = :P1, '
                || 'rank = :P2, '
                || 'military_service_id = :P3, '
                || 'title = :P4, '
                || 'corps = :P5, '
                || 'unit = :P6, '
                || 'squadron = :P7, '
                || 'phone = :P8, '
                || 'email = :P9, '
                || 'dims_id = :P10, '
                || 'uidpwd = :P11, '
                || 'must_change_password = :P12, '
                || 'supervisor_id = :P13 '
                || 'where provider_id = :P14';
      execute immediate v_vSql using
         pi_nLocked, pi_vName, pi_vRank, pi_nServiceID, pi_vTitle,
         pi_vCorps, pi_vSquadron, pi_vOfficeSymbol, pi_vPhone, pi_vEmail,
         pi_vDimsID, pi_vUIDPWD, pi_nMustChgPwd, pi_vSupervisorID, pi_vProviderID;
      commit;
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.UpdateSuatUser(): ' || sqlErrm;
   end;

   /*Get user rights recordset*/
   procedure GetUserRightsRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
  
      --open recordset
      v_vSql := 'select * '
                || 'from tbicds.stat_user_rights '
                || 'where active = 1 '
                || 'and visible = 1 '
                || 'order by sort_order, stat_right_id';
      open rs for v_vSql;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.GetUserRightsRS(): ' ||sqlErrm;
   end;

  /*Get user types recordset*/
   procedure GetUserTypesRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * '
                || 'from tbicds.stat_user_types '
                || 'where active = 1 '
                || 'and visible = 1 '
                || 'order by stat_usertype_id';
      open rs for v_vSql;
   
   exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_AP_USERADMIN.GetUserTypesRS(): ' || sqlErrm;
   end;
   
   /*get suat users recordset*/
   procedure GetSUATUsersRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
      v_vSQL varchar2(32767) := '';
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSQL := 'select t.*, t2.*, t3.user_name, t3.is_locked, t3.is_inactive ';
      v_vSQL := v_vSQL || 'from tbicds.app_user t, tbicds.fx_user_rights t2, tbicds.fx_user t3 ';
      v_vSQL := v_vSQL || 'where t2.fx_user_id = t.fx_user_id ';
      v_vSQL := v_vSQL || 'and t3.fx_user_id = t.fx_user_id ';
      v_vSQL := v_vSQL || 'and t.dims_id in (select dims_id from tbicds.app_user ';
      v_vSQL := v_vSQL || 'where fx_user_id = :USER_ID) ';
      v_vSQL := v_vSQL || 'order by t.name ';
      
      --open recordset
      open rs for v_vSQL using pi_nUserID;
   
   exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_AP_USERADMIN.GetSUATUsersRS(): ' || sqlErrm;
   end;
   
   /*get user specific permissions recordset*/
   procedure GetUserPermissionsRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      pi_nRights          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
      v_vSQL         varchar2(32767) := '';
      v_nRightsCount number := 0;
      v_nRights      number := 0;
      v_nReadOnly    number := 0;
      v_nPermissions number := 0;
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
   
      v_vSQL := 'select count(*) '
                || 'from tbicds.fx_user_rights t '
                || 'where t.fx_user_id = :P0 '
                || 'and bitand(t.user_rights, :P1) > 0';
      execute immediate v_vSQL into v_nRightsCount using pi_nUserID, pi_nRights;
      
      if (v_nRightsCount > 0) then
         v_vSQL := 'select t.user_rights, t.read_only '
                   || 'from tbicds.fx_user_rights t '
                   || 'where t.fx_user_id = :P0 '
                   || 'and bitand(t.user_rights, :P1) > 0';
         execute immediate v_vSQL into v_nRights, v_nReadOnly using pi_nUserID, pi_nRights; 
         
         if (bitand(pi_nRights, v_nReadOnly) > 0) then
            v_nPermissions := 1;
         else
            v_nPermissions := 2;
         end if;
      end if;
      
      v_vSQL := 'select :P0 as permissions from dual';
      open rs for v_vSQL using v_nPermissions;

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.GetUserPermissionsRS(): ' || sqlErrm;
   end;
   
   /*get supervisors recordset*/
   procedure GetInternSupervisorsRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
      v_vSQL varchar2(32767) := '';
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSQL := 'select * ';
      v_vSQL := v_vSQL || 'from tbicds.fx_user t1, tbicds.fx_user_rights t2, tbicds.app_user t3 ';
      v_vSQL := v_vSQL || 'where t2.fx_user_id = t1.fx_user_id ';
      v_vSQL := v_vSQL || 'and t3.fx_user_id = t1.fx_user_id ';
      v_vSQL := v_vSQL || 'and t2.user_type = 1 ';
      v_vSQL := v_vSQL || 'and t3.dims_id = (select t4.dims_id from tbicds.app_user t4 ';
      v_vSQL := v_vSQL || 'where t4.fx_user_id = :USER_ID) ';
      v_vSQL := v_vSQL || 'order by t3.name ';
      
      --open recordset
      open rs for v_vSQL using pi_nUserID;

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.GetInternSupervisorsRS(): ' || sqlErrm;
   end;
   
   /*insert rights template*/
   procedure InsertRightsTemplate (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      pi_nUserType        in number,
      pi_nUserRights      in number,
      pi_nRightsMode      in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2
      )
   is
      v_vSql                               varchar2(4000);
      v_nCount                             number := 0;
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
   
      v_vSql := 'select count(*) from tbicds.fx_rights_template t where t.user_type = :P0';
      execute immediate v_vSql into v_nCount using pi_nUserType;
   
      if v_nCount > 0 then
         UpdateRightsTemplate(pi_vSessionID => pi_vSessionID,
                              pi_vSessionClientIP => pi_vSessionClientIP, 
                              pi_nUserID => pi_nUserID,
                              pi_nUserType => pi_nUserType,
                              pi_nUserRights => pi_nUserRights,
                              pi_nRightsMode => pi_nRightsMode,
                              po_nStatusCode => po_nStatusCode, 
                              po_vStatusComment => po_vStatusComment);
      else
         v_vSql := 'insert into tbicds.fx_rights_template (user_type, user_rights, read_only) '
                   || 'values (:P0, :P1, :P2)';
         execute immediate v_vSql using pi_nUserType, pi_nUserRights, pi_nRightsMode;
         commit;
      end if;
   
   exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_AP_USERADMIN.InsertRightsTemplate(): ' ||
                           sqlErrm;
   end;
   
   /*update rights template*/
   procedure UpdateRightsTemplate (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      pi_nUserType        in number,
      pi_nUserRights      in number,
      pi_nRightsMode      in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.fx_rights_template t set '
                || 't.user_rights = :P0, t.read_only = :P1 '
                || 'where t.user_type = :P2';
      execute immediate v_vSql using pi_nUserRights, pi_nRightsMode, pi_nUserType;
      commit;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.UpdateRightsTemplate(): ' || sqlErrm;
   end;
   
   /*get rights template recordset*/
   procedure GetRightsTemplateRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      open rs for 'select * from tbicds.fx_rights_template t';

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.GetRightsTemplateRS(): ' || sqlErrm;
   end;

end;
/

